import os
_BASE = os.path.dirname(os.path.dirname(__file__))
def package_path(*parts):
    return os.path.join(_BASE, *parts)

def full_icon_path(icon_name: str) -> str:
    if not icon_name:
        return ""
    if os.path.isabs(icon_name):
        return icon_name
    # häufige Kandidaten in diesem Projekt
    candidates = [
        package_path("hub", "icons", icon_name),
        package_path("tools", "vertex_distributor", "icons", icon_name),
        package_path("assets", "icons", icon_name),
        package_path("icons", icon_name),
    ]
    for c in candidates:
        if os.path.exists(c):
            return c
    return icon_name

def full_icon_path(icon_name: str, entry: str = None, module_dir: str = None) -> str:
    """
    Liefert einen *absoluten* Pfad für icon_name.
    - Zuerst direkte Absolute prüfen.
    - URLs ignorieren (Shelf benötigt lokal).
    - Dann neben dem Tool (über entry oder module_dir) in ./icons/.
    - Danach übliche Projektpfade (hub/icons, tools/<tool>/icons, assets/icons, icons).
    - Fällt *niemals* auf eine URL zurück; wenn nicht auffindbar, gibt den Originalnamen zurück.
    """
    import importlib.util
    if not icon_name:
        return ""
    # Bereits absolut?
    if os.path.isabs(icon_name) and os.path.exists(icon_name):
        return icon_name

    # URL? -> Dateiname extrahieren, keine Remote-Icons
    if "://" in icon_name:
        icon_name_only = os.path.basename(icon_name.split("?")[0])
    else:
        icon_name_only = icon_name

    # Pfad relativ zum Tool ermitteln
    # (module_dir priorisieren, weil schneller/ohne importlib)
    def _check_dir(d):
        if not d:
            return None
        cand = os.path.join(d, "icons", icon_name_only)
        if os.path.exists(cand):
            return cand
        up1 = os.path.dirname(d)
        cand = os.path.join(up1, "icons", icon_name_only)
        if os.path.exists(cand):
            return cand
        return None

    cand = _check_dir(module_dir)
    if cand:
        return cand

    if entry:
        mod = entry.split(":", 1)[0] if ":" in entry else entry
        try:
            spec = importlib.util.find_spec(mod)
            if spec and spec.origin:
                base_dir = os.path.dirname(spec.origin)
                cand = _check_dir(base_dir)
                if cand:
                    return cand
        except Exception:
            pass

    # Projekt-nahe Kandidaten
    try:
        pkg_root = os.path.dirname(__file__)           # .../pjots_zen_tools/core
        pkg_root = os.path.dirname(pkg_root)           # .../pjots_zen_tools
        candidates = [
            os.path.join(pkg_root, "hub", "icons", icon_name_only),
            os.path.join(pkg_root, "assets", "icons", icon_name_only),
            os.path.join(pkg_root, "icons", icon_name_only),
        ]
        # heuristischer Tool-Ordner: tools/<name>/icons/<icon>
        tool_guess = os.path.splitext(icon_name_only)[0]
        candidates.append(os.path.join(pkg_root, "tools", tool_guess, "icons", icon_name_only))
        for c in candidates:
            if os.path.exists(c):
                return c
    except Exception:
        pass

    return icon_name
