# -*- coding: utf-8 -*-
# Metadata for the Zen Tools Hub.

# Preferred: single META dict
META = {
    "id": "zen_hub",
    "title": "PjotsZenTools Hub",
    "version": "1.1.8",
    "tags": ["hub", "tools", "manager","update"],
    "description": "<div style='text-align:left;'>\n<b>The Pjots Zen Hub</b> is the central management interface for all Zen Tools modules.<br>\nIt allows you to browse, install, update, and manage every tool within your Zen ecosystem — all directly inside Maya.<br>\nThe Hub also provides user registration, entitlement syncing, and automatic version checks to keep your workflow always up to date.<br><br>\n<b>Features</b><br>\n- One-click installation and updates for all Zen Tools<br>\n- Built-in entitlement and license management<br>\n- Integrated shelf creation and workspace synchronization<br>\n- Smart auto-update on startup (no manual refresh needed)<br>\n- Silent background version checks with detailed logs<br>\n- Lightweight Qt interface matching the Zen Theme<br>\n- Self-update mechanism to keep the Hub itself current\n</div>\n\n<div style='text-align:center;margin:18px 0;'>\n  <img src='https://updates.poweroftwo.studio/assets/zentoolshub.png' width='460' style='border-radius:12px;box-shadow:0 0 10px rgba(0,0,0,0.35);'>\n  <p style='color:#A9B1C3;font-size:11px;margin:4px 0 0 0;'>Pjots Zen Hub – Central Interface for Zen Tools</p>\n</div>\n\n<div style='text-align:left;'>\n<b>Versioning</b><br>\n1.0.0 – Initial public release of the Hub<br>\n1.0.3 – Improved entitlement sync and manifest handling<br>\n1.0.5 – Introduced full self-update functionality and background auto-check<br>\n1.1.2 – Introduced full ZenStyle on HUB<br>\n1.1.5 – Security Updates<br>\n1.1.7 – HiDPI support<br>\n1.1.8 – Feedback System introduced</div>",
    "icon": "icons/pjots_zen_tools_hub.png",
    "launcher": "pjots_zen_tools.hub.hub_ui:show",
}
